<?php

require_once("../packages/phpseclib/Net/SSH2.php");
require_once("../packages/phpseclib/Net/SFTP.php");

require_once("../packages/phpseclib/Crypt/RSA.php");
require_once("../packages/phpseclib/Math/BigInteger.php");
require_once("../packages/phpseclib/Crypt/Hash.php");
require_once("../packages/phpseclib/Crypt/Random.php");
require_once("../packages/phpseclib/Crypt/Base.php");
require_once("../packages/phpseclib/Crypt/Rijndael.php");
require_once("../packages/phpseclib/Crypt/AES.php");
require_once("../packages/phpseclib/Crypt/Blowfish.php");
require_once("../packages/phpseclib/Crypt/DES.php");
require_once("../packages/phpseclib/Crypt/RC2.php");
require_once("../packages/phpseclib/Crypt/RC4.php");
require_once("../packages/phpseclib/Crypt/TripleDES.php");
require_once("../packages/phpseclib/Crypt/Twofish.php");

require_once("FileIOUtility.php");

require_once("../php_excel/PHPExcel.php");
use phpseclib\Net\SFTP;

class SftpUtility
{

        /*
            NAME    : connect
            TYPE    : Utility function 
            DETAILS : 
            RETURN  : 
        */

        public function connect($ftp_host_name,$ftp_username,$ftp_user_password)
        {
            $sftp_connection = new SFTP($ftp_host_name);

            if($sftp_connection->login($ftp_username,$ftp_user_password))
            {
               return  $sftp_connection;
            }

           return null;
        }  

        /*
            NAME    : uploadFile
            TYPE    : Utility function 
            DETAILS : 
            RETURN  : 
        */
        public function uploadFile($sftp_connection,$local_file_path,$remote_file_path)
        {
            if($sftp_connection)
            {
                if(file_exists($local_file_path))
                {
                    $upload_result=$sftp_connection->put($remote_file_path,$local_file_path,SFTP::SOURCE_LOCAL_FILE);
                    if($upload_result)
                    {
                        return array("uploadStatus"=>"success");
                    }
                }
            }

            return array("uploadStatus"=>"failed");
        }



    public static function sftpFolder($ftp_remote_path,$year,$date,$plan_id){
        $sftp = new SFTP($ftp_server);
            
        if ($sftp->login($ftp_username, $ftp_password)) {

            if(!$sftp -> chdir($ftp_remote_path)){
                $sftp -> mkdir($ftp_remote_path);
                if(!$sftp -> chdir($ftp_remote_path.'/'.$year)){
                    $sftp -> mkdir($ftp_remote_path.'/'.$year);
                    if(!$sftp -> chdir($ftp_remote_path.'/'.$year.'/'.$date)){
                        $sftp -> mkdir($ftp_remote_path.'/'.$year.'/'.$date);
                    }elseif($sftp -> chdir($ftp_remote_path.'/'.$year)){
                        if(!$sftp -> chdir($ftp_remote_path.'/'.$year.'/'.$date)){
                            $sftp -> mkdir($ftp_remote_path.'/'.$year.'/'.$date);
                        }
                    }
                }
            }else{
                if(!$sftp -> chdir($ftp_remote_path.'/'.$year)){
                    $sftp -> mkdir($ftp_remote_path.'/'.$year);
                    if(!$sftp -> chdir($ftp_remote_path.'/'.$year.'/'.$date)){
                        $sftp -> mkdir($ftp_remote_path.'/'.$year.'/'.$date);
                    }
                }elseif($sftp -> chdir($ftp_remote_path.'/'.$year)){
                    if(!$sftp -> chdir($ftp_remote_path.'/'.$year.'/'.$date)){
                        $sftp -> mkdir($ftp_remote_path.'/'.$year.'/'.$date);
                    }
                }
            }
    
    
            if($sftp -> chdir($ftp_remote_path.'/'.$year.'/'.$date)){
                $sftp -> mkdir($ftp_remote_path.'/'.$year.'/'.$date.'/'.$plan_id);
                if($sftp ->chdir($ftp_remote_path.'/'.$year.'/'.$date.'/'.$plan_id)){
                    if(!$sftp -> chdir($ftp_remote_path.'/'.$year.'/'.$date.'/'.$plan_id.'/hra_assessment')){
                        $sftp -> mkdir($ftp_remote_path.'/'.$year.'/'.$date.'/'.$plan_id.'/hra_assessment');
                    }
                    if(!$sftp -> chdir($ftp_remote_path.'/'.$year.'/'.$date.'/'.$plan_id.'/summary_report')){
                        $sftp -> mkdir($ftp_remote_path.'/'.$year.'/'.$date.'/'.$plan_id.'/summary_report');
                    }
                }else{
                    if(!$sftp -> chdir($ftp_remote_path.'/'.$year.'/'.$date.'/'.$plan_id.'/hra_assessment')){
                        $sftp -> mkdir($ftp_remote_path.'/'.$year.'/'.$date.'/'.$plan_id.'/hra_assessment');
                    }
                    if(!$sftp -> chdir($ftp_remote_path.'/'.$year.'/'.$date.'/'.$plan_id.'/summary_report')){
                        $sftp -> mkdir($ftp_remote_path.'/'.$year.'/'.$date.'/'.$plan_id.'/summary_report');
                    }
                }
            }
        }

        unset($sftp);

    }

    public function uploadFilesToSftpMembeSummary($plan_id,$year,$memberId,$file_moved_path_location){
        include("../db.php");
        require_once("../php_excel/PHPExcel.php");

        date_default_timezone_set('America/New_York');
        $current_date = date("Y-m-d H:i:s");
        $date = date("mdY");

        //$response = new stdClass();

        //$response -> plan = $plan_id;
        //$response -> year = $year;

        $log = "";
        $log_path = "../../../pre_live_focuscares_api_ftp_logs";
    
        $log_file = $plan_id."_".$date.".log";
        $log_file_path = "$log_path/$date/$plan_id/$log_file";

        //Log File Path Creation
        FileIOUtility::SftplogFilePath($log_path,$date,$plan_id,$log_file);
	        
        $log = "";
        $log .= "[".date("m-d-Y H:i:s")."] Server Parameters : ".json_encode($_SERVER).PHP_EOL. PHP_EOL;
        $log .= "[".date("m-d-Y H:i:s")."] Plan : $plan_id". PHP_EOL;
        $log .= "[".date("m-d-Y H:i:s")."] Year : $year". PHP_EOL;
        
        file_put_contents($log_file_path, $log, FILE_APPEND);

        if($plan_id != ''){
            // Excel file name for download 
            $fileName = "FocusCare_Member_Summary_weekly Upload Report_Date $date.xlsx";             
            
            $excel_file_path = "../ftp_uploads/$date/$plan_id/$fileName";

            FileIOUtility :: SftpExcelUploadFolder($date, $plan_id, $fileName);
            
            // Create new PHPExcel object
            $objPHPExcel = new PHPExcel();

            if(file_exists($excel_file_path)){
                $objReader = PHPExcel_IOFactory::createReader("Excel2007");
        
                $objPHPExcel = $objReader->load($excel_file_path);
                $highest_row = $objPHPExcel->setActiveSheetIndex(0)->getHighestRow();
        
                $i = $highest_row;
                $j = $highest_row - 1;
            }else{
        
                $objPHPExcel->setActiveSheetIndex(0)
                    ->setCellValue('A1', 'Plan')
                    ->setCellValue('B1', 'Program')
                    ->setCellValue('C1', 'Year')
                    ->setCellValue('D1', 'LOB')
                    ->setCellValue('E1', 'Member ID')
                    ->setCellValue('F1', 'Member First Name')
                    ->setCellValue('G1', 'Member Last Name')
                    ->setCellValue('H1', 'Visit Type')
                    ->setCellValue('I1', 'Assessment Naming Convention')
                    ->setCellValue('J1', 'Date of Service')
                    ->setCellValue('K1', 'Date of Upload')
                    ->setCellValue('L1', 'Member Summary Status')
                    ->setCellValue('M1', 'Member Summary Reason');
                $i=1;
                $j=0;
            }
        
            $ftp_server = "";
            $ftp_username = "";
            $ftp_password = "";
            $ftp_remote_path = "";
       
            $query = "SELECT * FROM `hra_ftp_details` WHERE plan = 'DEMO'";
            
            file_put_contents($log_file_path, $log, FILE_APPEND);
            $select_query = mysqli_query($conn,$query);
      
            if(mysqli_num_rows($select_query) >= 1){
                $ftp_details = mysqli_fetch_assoc($select_query);
                if($ftp_details['active_status']=='Y'){
                    $ftp_server = $ftp_details['ftp_host'];
                    $ftp_username = $ftp_details['ftp_user'];
                    $ftp_password = $ftp_details['ftp_password'];
                    $ftp_remote_path = "/".$ftp_details['ftp_remote_path'];
         
                    $log .= "[".date("m-d-Y H:i:s")."] FTP HOST : ". base64_encode(convert_uuencode(base64_encode($ftp_server))).PHP_EOL.
                           "FTP USERNAME : ". base64_encode(convert_uuencode(base64_encode($ftp_username))).PHP_EOL
                    ;
        
                }else{
                    $log .= "[".date("m-d-Y H:i:s")."]".json_encode("$plan_id is not active for uploading files to FTP Server").PHP_EOL;
                    $log.="-------------------------------------------------------------------------------------------------------------".PHP_EOL.PHP_EOL;
                    file_put_contents($log_file_path, $log, FILE_APPEND);

                    echo "$plan_id is not active for uploading files to FTP Server";
                    return false;
                    //$response =array("status" => 0 ,"FTP Response" =>"$plan_id is not active for uploading files to FTP Server");
                    //$response->status = 0;
                    //$response->message = "$plan_id is not active for uploading files to FTP Server";
                    //$response->fax_response = $fax_response_obejct;
                    //return json_encode($response);
                    
                }

                $sftp = new SFTP($ftp_server);
            
                if ($sftp->login($ftp_username, $ftp_password)) {
 
                    if(!$sftp -> chdir($ftp_remote_path)){
                        $sftp -> mkdir($ftp_remote_path);
                        if(!$sftp -> chdir($ftp_remote_path.'/'.$year)){
                            $sftp -> mkdir($ftp_remote_path.'/'.$year);
                            if(!$sftp -> chdir($ftp_remote_path.'/'.$year.'/'.$date)){
                                $sftp -> mkdir($ftp_remote_path.'/'.$year.'/'.$date);
                            }elseif($sftp -> chdir($ftp_remote_path.'/'.$year)){
                                if(!$sftp -> chdir($ftp_remote_path.'/'.$year.'/'.$date)){
                                    $sftp -> mkdir($ftp_remote_path.'/'.$year.'/'.$date);
                                }
                            }
                        }
                    }else{
                        if(!$sftp -> chdir($ftp_remote_path.'/'.$year)){
                            $sftp -> mkdir($ftp_remote_path.'/'.$year);
                            if(!$sftp -> chdir($ftp_remote_path.'/'.$year.'/'.$date)){
                                $sftp -> mkdir($ftp_remote_path.'/'.$year.'/'.$date);
                            }
                        }elseif($sftp -> chdir($ftp_remote_path.'/'.$year)){
                            if(!$sftp -> chdir($ftp_remote_path.'/'.$year.'/'.$date)){
                                $sftp -> mkdir($ftp_remote_path.'/'.$year.'/'.$date);
                            }
                        }
                    }
            
            
                    if($sftp -> chdir($ftp_remote_path.'/'.$year.'/'.$date)){
                        $sftp -> mkdir($ftp_remote_path.'/'.$year.'/'.$date.'/'.$plan_id);
                        if($sftp ->chdir($ftp_remote_path.'/'.$year.'/'.$date.'/'.$plan_id)){
                            if(!$sftp -> chdir($ftp_remote_path.'/'.$year.'/'.$date.'/'.$plan_id.'/member_summary_report')){
                                $sftp -> mkdir($ftp_remote_path.'/'.$year.'/'.$date.'/'.$plan_id.'/member_summary_report');
                            }
                        }else{
                            if(!$sftp -> chdir($ftp_remote_path.'/'.$year.'/'.$date.'/'.$plan_id.'/member_summary_report')){
                                $sftp -> mkdir($ftp_remote_path.'/'.$year.'/'.$date.'/'.$plan_id.'/member_summary_report');
                            }
                        }
                    }
            
                    $getClientsids =  "SELECT active_status,clientId, program FROM HRA_client LEFT JOIN hra_ftp_details as ftp ON ftp.plan = HRA_client.plan where HRA_client.plan= '".$plan_id."' and year like  '%".$year."%' ";
                    //$getClientsids =  "SELECT clientId, program FROM HRA_client where HRA_client.plan= '".$plan_id."' and year like  '%".$year."%' ";
            
                    $getClientsidsresult=mysqli_query($conn,$getClientsids);
                    $sql_global_member_query = array();
                    $sql_global_member_query1 = array();
            
                    while($getClientsidsresp=mysqli_fetch_array($getClientsidsresult,MYSQLI_ASSOC)){
                        $client_id =  $getClientsidsresp['clientId'];
                        $substatus_column = "";
            
                        $overrideScheduleDate_column = "(
                            CASE
                            WHEN EvaluationDate IS NOT NULL AND scheduleDate IS NOT NULL THEN EvaluationDate 
                            ELSE scheduleDate
                            END
                        ) AS  overrideScheduledDate";
            
                        $overrideShortScheduleDate_column = "(
                            CASE
                                WHEN EvaluationDate IS NOT NULL AND scheduleDate IS NOT NULL THEN STR_TO_DATE(EvaluationDate, '%Y-%m-%d')
                                ELSE STR_TO_DATE(scheduleDate, '%Y-%m-%d')
                            END
                            ) AS  overrideShortScheduledDate";
                        $completed_date_column = "( CASE 
                            WHEN JSON_LENGTH(JSON_UNQUOTE(JSON_EXTRACT(hraStatusHistory, '$.completed'))) <> 0 THEN JSON_UNQUOTE(JSON_EXTRACT(hraStatusHistory,CONCAT('$.completed[',JSON_LENGTH(`hraStatusHistory` , '$.completed')-1,'].date')))
            
            
                            END ) AS completed_date";
            
                        $combine_member_query[] = "select member_id, $completed_date_column,hraStatus,clientid,year, memberinfo,$overrideScheduleDate_column,$overrideShortScheduleDate_column,scheduleDate, VisitType, member_pdf_file_name, member_ftp_upload_status from HRA_member_".$client_id.'_'.$year;
                        $combine_member_query1['active'] = $getClientsidsresp['active_status'];
                    } 
                    $combine_member_query1['active']='Y';
                    if($combine_member_query1['active']=='Y'){
                        if($combine_member_query && is_array($combine_member_query))
                        {
                            $sql_global_member_query1 = implode(" UNION ALL ", $combine_member_query);
                            
            
                            //$sql_global_member_query1 = "select (COUNT(*) OVER()) as totalRows,member_info.* from (". $sql_global_member_query1 . " ) as  member_info  where JSON_UNQUOTE(JSON_EXTRACT(member_info.hraStatus, '$.hraStatus')) in(10,11)  AND  member_pdf_file_name !='' AND (member_ftp_upload_status IS NULL or member_ftp_upload_status='')  AND member_id = '$memberId'";
            
                            $sql_global_member_query1 = "select (COUNT(*) OVER()) as totalRows,member_info.* from (". $sql_global_member_query1 . " ) as  member_info  where member_pdf_file_name !='' AND member_id = '$memberId'";
                            
                            //echo $sql_global_member_query1;exit;

                            $log .= "[".date("m-d-Y H:i:s")."] QUERY : $sql_global_member_query1". PHP_EOL;
                            file_put_contents($log_file_path, $log, FILE_APPEND);

                            $memberrecordscount = mysqli_query($conn,$sql_global_member_query1);
            
                            $go_any_where_status = array("member_uploadStatus" => "failed" , "reason_member_upload" => "", "member_id" => "" , "client_id" => $client_id , "year" => $year, "member_ftp_upload_date" => $current_date , "member_assessment_name" => "");
                            if(mysqli_num_rows($memberrecordscount)){
                            while($member_row = mysqli_fetch_array($memberrecordscount,MYSQLI_ASSOC))
                            {
                                $i++;
                                $j++;
                                $memberId = $member_row['member_id'];
                                $clientId = $member_row['clientid'];
                                $year = $member_row['year'];
                                $form_type = "member_summary_report";
                                $fileepath = "../member_data/HRA_member_".$clientId.'/'.$year;
                                //$local_file_to_upload = $fileepath.'/'.$form_type.'/'.$memberId.'.pdf';
            
                                //$file_name_with_extention = $memberId.'.pdf';
            
            
            
                                $meminfo =  json_decode($member_row['memberinfo'],true);
                                if($member_row['member_pdf_file_name'] != ''){
                                    $file_name = $member_row['member_pdf_file_name'];
                                }else{
                                    $file_name = "Member_Summary_". $memberId.".pdf";
                                }
            
                                $local_file_to_upload = $fileepath.'/'.$form_type.'/'.$file_name;
                                $file_name = str_replace("*","_",$file_name);

                                $program = $meminfo['Program'];
            
                                $remote_file_path_member="$ftp_remote_path/$year/$date/$plan_id/member_summary_report";
            
                                $log .= "[".date("m-d-Y H:i:s")."] Member Report File Path : ". $remote_file_path_member. PHP_EOL;            
                                
                                $go_any_where_status = array("member_uploadStatus" => "failed" , "reason_member_upload" => "", "member_id" => $memberId , "client_id" => $clientId , "year" => $year, "member_ftp_upload_date" => $current_date , "member_assessment_name" => $file_name);
            
                                if(file_exists($local_file_to_upload))
                                {
                                    if($sftp->chdir($remote_file_path_member)){
                                        if($sftp->put($file_name, $local_file_to_upload, SFTP::SOURCE_LOCAL_FILE)){
            
                                            $go_any_where_status = array("member_uploadStatus" => "success" , "reason_member_upload" => "uploaded Member Report", "member_id" => $memberId , "client_id" => $clientId , "year" => $year, "member_ftp_upload_date" => $current_date , "member_assessment_name" => $file_name);
                                    
                                        }else{

                                            $go_any_where_status = array("member_uploadStatus" => "failed" , "reason_member_upload" => "not uploaded in ftp server for Member Report", "member_id" => $memberId , "client_id" => $clientId , "year" => $year, "member_ftp_upload_date" => $current_date , "member_assessment_name" => $file_name);
                                        }
                                    }else{
                                        $go_any_where_status = array("member_uploadStatus" => "failed" , "reason_member_upload" => "directory $remote_file_path_mwmber not existed in ftp server for Member Report", "member_id" => $memberId , "client_id" => $clientId , "year" => $year, "member_ftp_upload_date" => $current_date , "member_assessment_name" => $file_name);
  
                                     }            
                                }else{

                                    $go_any_where_status = array("member_uploadStatus" => "failed" , "reason_member_upload" => "$file_name is not existed for Member Report", "member_id" => $memberId , "client_id" => $clientId , "year" => $year, "member_ftp_upload_date" => $current_date , "member_assessment_name" => $file_name);
                           
                                }
            
            
                                $file_name = mysqli_real_escape_string($conn,$file_name);
                                $update_Query = "UPDATE HRA_member_".$clientId.'_'.$year. " SET member_ftp_upload_status = '".json_encode($go_any_where_status)."' where member_id = '". $memberId."'";
                                //echo $update_Query;
                                mysqli_query($conn, $update_Query) ;
                                //echo json_encode($go_any_where_status);
                                //$response -> ftp_response = json_encode($go_any_where_status);
                                $log .= "[".date("m-d-Y H:i:s")."] ". json_encode($go_any_where_status).PHP_EOL;
                                //exit;
                                if($go_any_where_status['member_uploadStatus'] == "failed"){
                                    $local_file_to_upload = mysqli_real_escape_string($conn,$local_file_to_upload);
                                    $memberId = mysqli_real_escape_string($conn,$memberId);
                                    $insert_query = "INSERT INTO ftp_error_logs( member_id, clientid, `year`, filepath, cron_type, reason) VALUES ('$memberId','$clientId',$year,'$local_file_to_upload','Member_Summary_Weekly_Upload_Completed_records_hra_assessment','".$go_any_where_status['reason_hra']."') ";
            
                                    //echo $insert_query;
            
                                    $query = mysqli_query($conn,$insert_query);
            
                                }
            
                                $objPHPExcel->setActiveSheetIndex(0)
                                    ->setCellValue("A$i", $plan_id)
                                    ->setCellValue("B$i", $program)
                                    ->setCellValue("C$i", $year)
                                    ->setCellValue("D$i", $meminfo['LOB'])
                                    ->setCellValue("E$i", $memberId)
                                    ->setCellValue("F$i", $meminfo['Member_first_name'])
                                    ->setCellValue("G$i", $meminfo["Member_Last_name"])
                                    ->setCellValue("H$i", $member_row['VisitType'])
                                    ->setCellValue("I$i", $file_name)
                                    ->setCellValue("J$i", date("m-d-Y", strtotime($member_row['overrideShortScheduledDate']) ))
                                    ->setCellValue("K$i",  date("m-d-Y"))
                                    ->setCellValue("L$i", $go_any_where_status['member_uploadStatus'])
                                    ->setCellValue("M$i", $go_any_where_status['reason_member']);
                                    
            
                            }
                        }else{
                            $i++;
                            $j++;
                            $objPHPExcel->setActiveSheetIndex(0)
                                    ->setCellValue("A$i", $plan_id)
                                    ->setCellValue("B$i", "")
                                    ->setCellValue("C$i", $year)
                                    ->setCellValue("D$i", "")
                                    ->setCellValue("E$i", "No Records found")
                                    ->setCellValue("F$i", "")
                                    ->setCellValue("G$i", "")
                                    ->setCellValue("H$i", "")
                                    ->setCellValue("I$i", "")
                                    ->setCellValue("J$i", "")
                                    ->setCellValue("K$i",  date("m-d-Y"))
                                    ->setCellValue("L$i", "")
                                    ->setCellValue("M$i", "");
                                    
                        }
            
            
            
                            $objPHPExcel->getActiveSheet()->setTitle('Sheet1');
            
            
                            // Set active sheet index to the first sheet, so Excel opens this as the first sheet
                            $objPHPExcel->setActiveSheetIndex(0);
            
                            // Redirect output to a client’s web browser (Excel5)
                            header("Content-Type: application/vnd.ms-excel");
                            header("Content-Disposition: attachment; filename=".$fileName);
                            header("Cache-Control: max-age=0");
            
                            // Save Excel 2007 file
                            $objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel2007');
                            // echo str_replace('.php', '.xlsx', __FILE__);
                            // echo $excel_file_path;
                            //$objWriter->save(str_replace('.php', '.xlsx', __FILE__));
                            $objWriter->save($excel_file_path);
            
                            unset($objWriter);
                            unset($objPHPExcel);
                            unset($sftp);
            
                            $sftp = new SFTP($ftp_server);
            
                            if ($sftp->login($ftp_username, $ftp_password)) {
                                if(!$sftp -> chdir($ftp_remote_path.'/'.$year.'/'.$date.'/'.$plan_id.'/monthly_report')){
                                    $sftp -> mkdir($ftp_remote_path.'/'.$year.'/'.$date.'/'.$plan_id.'/monthly_report');
                                }
                                $remote_monthly_file ="$ftp_remote_path/$year/$date/$plan_id/monthly_report/";
                                //$remote_weekly_file = "/"; 
                                $excel_file_path = "../ftp_uploads/$date/$plan_id/$fileName";
            
                                if($sftp->chdir($remote_monthly_file)){
                                //if($sftp->put($remote_weekly_file.$fileName, $excel_file_path , SFTP::SOURCE_LOCAL_FILE)){
                                if($sftp->put($remote_monthly_file.$fileName, $excel_file_path , SFTP::SOURCE_LOCAL_FILE)){
                                    unlink(str_replace('.php', '.xlsx', __FILE__));
                                    $ftp_excel ="Uploaded excel file";
                                    $log .= "[".date("m-d-Y H:i:s")."] Uploaded excel file".PHP_EOL;
            
                                }else{
                                    $ftp_excel =  "uploaded excel file";
                                    $log .= "[".date("m-d-Y H:i:s")."] Not uploaded excel file".PHP_EOL ;
                                }
                                //echo $ftp_excel;
                                }
                            }
                            //$ftp_response = array("FTP_Response" => $go_any_where_status, "FTP_Excel" => $ftp_excel);
                            //$ftp_response = json_decode(json_encode($ftp_response), true);
                            //$response -> status = 1;
                            //$response -> message = "Uploaded to ftp server";
                            //$response -> ftp_response = json_encode($ftp_response);
                            
                        }
                    }else{
                        echo "$plan_id is inactive";
                        //$response = array("status" => 0 ,"FTP Response" =>"$plan_id is inactive");

                        //$response->status = 0;
                        //$response->message = "$plan_id is inactive";
                        $log .= "[".date("m-d-Y H:i:s")."] $plan_id is inactive". PHP_EOL;
                    }
                }else{
                    echo "Unable to login to sftp server";
                    //$response =array( "status" => 0 ,"FTP Response" => "Unable to login to sftp server");
                    //$response->status = 0;
                    //$response->message = "Unable to login to sftp server";
                    $log .= "[".date("m-d-Y H:i:s")."] Unable to login to sftp server". PHP_EOL;
                }
            }else{
                $log .= "[".date("m-d-Y H:i:s")."]".json_encode("No client is active with $plan_id"). PHP_EOL;
                $log.="-------------------------------------------------------------------------------------------------------------".PHP_EOL.PHP_EOL;
                file_put_contents($log_file_path, $log, FILE_APPEND);
                
                echo "No client is active with $plan_id";
                //$response = array("status" => 0 ,"FTP Response" =>"No client is active with $plan_id");
                //return json_encode($response);

                //$response->status = 0;
                  //  $response->message = "No client is active with $plan_id";
                    //$response->fax_response = $fax_response_obejct;
                   // return json_encode($response);

            }
       


        }else{
            $log .= "[".date("m-d-Y H:i:s")."] Plan Id is empty". PHP_EOL;
            //$response = "Plan Id is empty";
            //$response->status = 0;
            //$response->message = "Plan Id is empty";
            echo "Plan Id is empty";
        }

            
            //Save string to log, use FILE_APPEND to append.
            $log.="-------------------------------------------------------------------------------------------------------------".PHP_EOL.PHP_EOL;
            file_put_contents($log_file_path, $log, FILE_APPEND);

        //echo json_encode($response);
        return;
    }

    public function memberMonthlyFtpUpload($plan_id,$year){
        include("../db.php");
        require_once("../php_excel/PHPExcel.php");

        date_default_timezone_set('America/New_York');
        $current_date = date("Y-m-d H:i:s");
        $date = date("mdY");

        //$response = new stdClass();

        //$response -> plan = $plan_id;
        //$response -> year = $year;

        $log = "";
        $log_path = "../../../pre_live_focuscares_api_ftp_logs";
    
        $log_file = $plan_id."_".$date.".log";
        $log_file_path = "$log_path/$date/$plan_id/$log_file";

        //Log File Path Creation
        FileIOUtility::SftplogFilePath($log_path,$date,$plan_id,$log_file);
	        
        $log = "";
        $log .= "[".date("m-d-Y H:i:s")."] Server Parameters : ".json_encode($_SERVER).PHP_EOL. PHP_EOL;
        $log .= "[".date("m-d-Y H:i:s")."] Plan : $plan_id". PHP_EOL;
        $log .= "[".date("m-d-Y H:i:s")."] Year : $year". PHP_EOL;
        
        file_put_contents($log_file_path, $log, FILE_APPEND);

        if($plan_id != ''){
            // Excel file name for download 
            $fileName = "FocusCare_monthly Upload Report_Date $date.xlsx";             
            
            $excel_file_path = "../ftp_uploads/$date/$plan_id/$fileName";

            FileIOUtility :: SftpExcelUploadFolder($date, $plan_id, $fileName);
            
            // Create new PHPExcel object
            $objPHPExcel = new PHPExcel();

            if(file_exists($excel_file_path)){
                $objReader = PHPExcel_IOFactory::createReader("Excel2007");
        
                $objPHPExcel = $objReader->load($excel_file_path);
                $highest_row = $objPHPExcel->setActiveSheetIndex(0)->getHighestRow();
        
                $i = $highest_row;
                $j = $highest_row - 1;
            }else{
        
                $objPHPExcel->setActiveSheetIndex(0)
                    ->setCellValue('A1', 'Plan')
                    ->setCellValue('B1', 'Program')
                    ->setCellValue('C1', 'Year')
                    ->setCellValue('D1', 'LOB')
                    ->setCellValue('E1', 'Member ID')
                    ->setCellValue('F1', 'Member First Name')
                    ->setCellValue('G1', 'Member Last Name')
                    ->setCellValue('H1', 'Visit Type')
                    ->setCellValue('I1', 'Assessment Naming Convention')
                    ->setCellValue('J1', 'Date of Service')
                    ->setCellValue('K1', 'Date of Upload')
                    ->setCellValue('L1', 'Member Summary Status')
                    ->setCellValue('M1', 'Member Summary Reason');
                $i=1;
                $j=0;
            }
        
            $ftp_server = "";
            $ftp_username = "";
            $ftp_password = "";
            $ftp_remote_path = "";
       
            $query = "SELECT * FROM `hra_ftp_details` WHERE plan = 'DEMO'";
            
            file_put_contents($log_file_path, $log, FILE_APPEND);
            $select_query = mysqli_query($conn,$query);
      
            if(mysqli_num_rows($select_query) >= 1){
                $ftp_details = mysqli_fetch_assoc($select_query);
                if($ftp_details['active_status']=='Y'){
                    $ftp_server = $ftp_details['ftp_host'];
                    $ftp_username = $ftp_details['ftp_user'];
                    $ftp_password = $ftp_details['ftp_password'];
                    $ftp_remote_path = "/".$ftp_details['ftp_remote_path'];
         
                    $log .= "[".date("m-d-Y H:i:s")."] FTP HOST : ". base64_encode(convert_uuencode(base64_encode($ftp_server))).PHP_EOL.
                           "FTP USERNAME : ". base64_encode(convert_uuencode(base64_encode($ftp_username))).PHP_EOL
                    ;
        
                }else{
                    $log .= "[".date("m-d-Y H:i:s")."]".json_encode("$plan_id is not active for uploading files to FTP Server").PHP_EOL;
                    $log.="-------------------------------------------------------------------------------------------------------------".PHP_EOL.PHP_EOL;
                    file_put_contents($log_file_path, $log, FILE_APPEND);

                    echo "$plan_id is not active for uploading files to FTP Server";
                    return false;
                    //$response =array("status" => 0 ,"FTP Response" =>"$plan_id is not active for uploading files to FTP Server");
                    //$response->status = 0;
                    //$response->message = "$plan_id is not active for uploading files to FTP Server";
                    //$response->fax_response = $fax_response_obejct;
                    //return json_encode($response);
                    
                }

                $sftp = new SFTP($ftp_server);
            
                if ($sftp->login($ftp_username, $ftp_password)) {
 
                    if(!$sftp -> chdir($ftp_remote_path)){
                        $sftp -> mkdir($ftp_remote_path);
                        if(!$sftp -> chdir($ftp_remote_path.'/'.$year)){
                            $sftp -> mkdir($ftp_remote_path.'/'.$year);
                            if(!$sftp -> chdir($ftp_remote_path.'/'.$year.'/'.$date)){
                                $sftp -> mkdir($ftp_remote_path.'/'.$year.'/'.$date);
                            }elseif($sftp -> chdir($ftp_remote_path.'/'.$year)){
                                if(!$sftp -> chdir($ftp_remote_path.'/'.$year.'/'.$date)){
                                    $sftp -> mkdir($ftp_remote_path.'/'.$year.'/'.$date);
                                }
                            }
                        }
                    }else{
                        if(!$sftp -> chdir($ftp_remote_path.'/'.$year)){
                            $sftp -> mkdir($ftp_remote_path.'/'.$year);
                            if(!$sftp -> chdir($ftp_remote_path.'/'.$year.'/'.$date)){
                                $sftp -> mkdir($ftp_remote_path.'/'.$year.'/'.$date);
                            }
                        }elseif($sftp -> chdir($ftp_remote_path.'/'.$year)){
                            if(!$sftp -> chdir($ftp_remote_path.'/'.$year.'/'.$date)){
                                $sftp -> mkdir($ftp_remote_path.'/'.$year.'/'.$date);
                            }
                        }
                    }
            
            
                    if($sftp -> chdir($ftp_remote_path.'/'.$year.'/'.$date)){
                        $sftp -> mkdir($ftp_remote_path.'/'.$year.'/'.$date.'/'.$plan_id);
                        if($sftp ->chdir($ftp_remote_path.'/'.$year.'/'.$date.'/'.$plan_id)){
                            if(!$sftp -> chdir($ftp_remote_path.'/'.$year.'/'.$date.'/'.$plan_id.'/member_summary_report')){
                                $sftp -> mkdir($ftp_remote_path.'/'.$year.'/'.$date.'/'.$plan_id.'/member_summary_report');
                            }
                        }else{
                            if(!$sftp -> chdir($ftp_remote_path.'/'.$year.'/'.$date.'/'.$plan_id.'/member_summary_report')){
                                $sftp -> mkdir($ftp_remote_path.'/'.$year.'/'.$date.'/'.$plan_id.'/member_summary_report');
                            }
                        }
                    }
            
                    $getClientsids =  "SELECT active_status,clientId, program FROM HRA_client LEFT JOIN hra_ftp_details as ftp ON ftp.plan = HRA_client.plan where HRA_client.plan= '".$plan_id."' and year like  '%".$year."%' ";
                    //$getClientsids =  "SELECT clientId, program FROM HRA_client where HRA_client.plan= '".$plan_id."' and year like  '%".$year."%' ";
            
                    $getClientsidsresult=mysqli_query($conn,$getClientsids);
                    $sql_global_member_query = array();
                    $sql_global_member_query1 = array();
            
                    while($getClientsidsresp=mysqli_fetch_array($getClientsidsresult,MYSQLI_ASSOC)){
                        $client_id =  $getClientsidsresp['clientId'];
                        $substatus_column = "";
            
                        $overrideScheduleDate_column = "(
                            CASE
                            WHEN EvaluationDate IS NOT NULL AND scheduleDate IS NOT NULL THEN EvaluationDate 
                            ELSE scheduleDate
                            END
                        ) AS  overrideScheduledDate";
            
                        $overrideShortScheduleDate_column = "(
                            CASE
                                WHEN EvaluationDate IS NOT NULL AND scheduleDate IS NOT NULL THEN STR_TO_DATE(EvaluationDate, '%Y-%m-%d')
                                ELSE STR_TO_DATE(scheduleDate, '%Y-%m-%d')
                            END
                            ) AS  overrideShortScheduledDate";
                        $completed_date_column = "( CASE 
                            WHEN JSON_LENGTH(JSON_UNQUOTE(JSON_EXTRACT(hraStatusHistory, '$.completed'))) <> 0 THEN JSON_UNQUOTE(JSON_EXTRACT(hraStatusHistory,CONCAT('$.completed[',JSON_LENGTH(`hraStatusHistory` , '$.completed')-1,'].date')))
            
            
                            END ) AS completed_date";
            
                        $combine_member_query[] = "select member_id, $completed_date_column,hraStatus,clientid,year, memberinfo,$overrideScheduleDate_column,$overrideShortScheduleDate_column,scheduleDate, VisitType, member_pdf_file_name, member_ftp_upload_status from HRA_member_".$client_id.'_'.$year;
                        $combine_member_query1['active'] = $getClientsidsresp['active_status'];
                    } 
                    $combine_member_query1['active']='Y';
                    if($combine_member_query1['active']=='Y'){
                        if($combine_member_query && is_array($combine_member_query))
                        {
                            $sql_global_member_query1 = implode(" UNION ALL ", $combine_member_query);
                            
            
                            //$sql_global_member_query1 = "select (COUNT(*) OVER()) as totalRows,member_info.* from (". $sql_global_member_query1 . " ) as  member_info  where JSON_UNQUOTE(JSON_EXTRACT(member_info.hraStatus, '$.hraStatus')) in(10,11)  AND  member_pdf_file_name !='' AND (member_ftp_upload_status IS NULL or member_ftp_upload_status='' )";
                            
                            $sql_global_member_query1 = "select (COUNT(*) OVER()) as totalRows,member_info.* from (". $sql_global_member_query1 . " ) as  member_info  where member_pdf_file_name !='' ";
                            
                            //echo $sql_global_member_query1;exit;
                            $log .= "[".date("m-d-Y H:i:s")."] QUERY : $sql_global_member_query1". PHP_EOL;
                            file_put_contents($log_file_path, $log, FILE_APPEND);
                            $memberrecordscount = mysqli_query($conn,$sql_global_member_query1);
            
                            $go_any_where_status = array("member_uploadStatus" => "failed" , "reason_member_upload" => "", "member_id" => "" , "client_id" => $client_id , "year" => $year, "member_ftp_upload_date" => $current_date , "member_assessment_name" => "");
                            if(mysqli_num_rows($memberrecordscount)){
                            while($member_row = mysqli_fetch_array($memberrecordscount,MYSQLI_ASSOC))
                            {
                                $i++;
                                $j++;
                                $memberId = $member_row['member_id'];
                                $clientId = $member_row['clientid'];
                                $year = $member_row['year'];
                                $form_type = "member_summary_report";
                                $fileepath = "../member_data/HRA_member_".$clientId.'/'.$year;
                                //$local_file_to_upload = $fileepath.'/'.$form_type.'/'.$memberId.'.pdf';
            
                                //$file_name_with_extention = $memberId.'.pdf';
            
            
            
                                $meminfo =  json_decode($member_row['memberinfo'],true);
                                if($member_row['member_pdf_file_name'] != ''){
                                    $file_name = $member_row['member_pdf_file_name'];
                                }else{
                                    $file_name = "Member_Summary_". $memberId.".pdf";
                                }
            
                                $local_file_to_upload = $fileepath.'/'.$form_type.'/'.$file_name;
                                $file_name = str_replace("*","_",$file_name);

                                $program = $meminfo['Program'];
            
                                $remote_file_path_member="$ftp_remote_path/$year/$date/$plan_id/member_summary_report";
            
                                $log .= "[".date("m-d-Y H:i:s")."] Member Report File Path : ". $remote_file_path_member. PHP_EOL;            
                                
                                $go_any_where_status = array("member_uploadStatus" => "failed" , "reason_member_upload" => "", "member_id" => $memberId , "client_id" => $clientId , "year" => $year, "member_ftp_upload_date" => $current_date , "member_assessment_name" => $file_name);
            
                                if(file_exists($local_file_to_upload))
                                {
                                    if($sftp->chdir($remote_file_path_member)){
                                        if($sftp->put($file_name, $local_file_to_upload, SFTP::SOURCE_LOCAL_FILE)){
            
                                            $go_any_where_status = array("member_uploadStatus" => "success" , "reason_member_upload" => "uploaded Member Report", "member_id" => $memberId , "client_id" => $clientId , "year" => $year, "member_ftp_upload_date" => $current_date , "member_assessment_name" => $file_name);
                                    
                                        }else{

                                            $go_any_where_status = array("member_uploadStatus" => "failed" , "reason_member_upload" => "not uploaded in ftp server for Member Report", "member_id" => $memberId , "client_id" => $clientId , "year" => $year, "member_ftp_upload_date" => $current_date , "member_assessment_name" => $file_name);
                                        }
                                    }else{
                                        $go_any_where_status = array("member_uploadStatus" => "failed" , "reason_member_upload" => "directory $remote_file_path_mwmber not existed in ftp server for Member Report", "member_id" => $memberId , "client_id" => $clientId , "year" => $year, "member_ftp_upload_date" => $current_date , "member_assessment_name" => $file_name);
  
                                     }            
                                }else{

                                    $go_any_where_status = array("member_uploadStatus" => "failed" , "reason_member_upload" => "$file_name is not existed for Member Report", "member_id" => $memberId , "client_id" => $clientId , "year" => $year, "member_ftp_upload_date" => $current_date , "member_assessment_name" => $file_name);
                           
                                }
            
            
                                $file_name = mysqli_real_escape_string($conn,$file_name);
                                $update_Query = "UPDATE HRA_member_".$clientId.'_'.$year. " SET member_ftp_upload_status = '".json_encode($go_any_where_status)."' where member_id = '". $memberId."'";
                                //echo $update_Query;
                                mysqli_query($conn, $update_Query) ;
                                echo json_encode($go_any_where_status);
                                $log .= "[".date("m-d-Y H:i:s")."] ". json_encode($go_any_where_status).PHP_EOL;
                                //exit;
                                if($go_any_where_status['member_uploadStatus'] == "failed"){
                                    $local_file_to_upload = mysqli_real_escape_string($conn,$local_file_to_upload);
                                    $memberId = mysqli_real_escape_string($conn,$memberId);
                                    $insert_query = "INSERT INTO ftp_error_logs( member_id, clientid, `year`, filepath, cron_type, reason) VALUES ('$memberId','$clientId',$year,'$local_file_to_upload','Monthly_Upload_Completed_records_hra_assessment','".$go_any_where_status['reason_hra']."') ";
            
                                    //echo $insert_query;
            
                                    $query = mysqli_query($conn,$insert_query);
            
                                }
            
                                $objPHPExcel->setActiveSheetIndex(0)
                                    ->setCellValue("A$i", $plan_id)
                                    ->setCellValue("B$i", $program)
                                    ->setCellValue("C$i", $year)
                                    ->setCellValue("D$i", $meminfo['LOB'])
                                    ->setCellValue("E$i", $memberId)
                                    ->setCellValue("F$i", $meminfo['Member_first_name'])
                                    ->setCellValue("G$i", $meminfo["Member_Last_name"])
                                    ->setCellValue("H$i", $member_row['VisitType'])
                                    ->setCellValue("I$i", $file_name)
                                    ->setCellValue("J$i", date("m-d-Y", strtotime($member_row['overrideShortScheduledDate']) ))
                                    ->setCellValue("K$i",  date("m-d-Y"))
                                    ->setCellValue("L$i", $go_any_where_status['member_uploadStatus'])
                                    ->setCellValue("M$i", $go_any_where_status['reason_member']);
                                    
            
                            }
                        }else{
                            $i++;
                            $j++;
                            $objPHPExcel->setActiveSheetIndex(0)
                                    ->setCellValue("A$i", $plan_id)
                                    ->setCellValue("B$i", "")
                                    ->setCellValue("C$i", $year)
                                    ->setCellValue("D$i", "")
                                    ->setCellValue("E$i", "No Records found")
                                    ->setCellValue("F$i", "")
                                    ->setCellValue("G$i", "")
                                    ->setCellValue("H$i", "")
                                    ->setCellValue("I$i", "")
                                    ->setCellValue("J$i", "")
                                    ->setCellValue("K$i",  date("m-d-Y"))
                                    ->setCellValue("L$i", "")
                                    ->setCellValue("M$i", "");
                                    
                        }
            
            
            
                            $objPHPExcel->getActiveSheet()->setTitle('Sheet1');
            
            
                            // Set active sheet index to the first sheet, so Excel opens this as the first sheet
                            $objPHPExcel->setActiveSheetIndex(0);
            
                            // Redirect output to a client’s web browser (Excel5)
                            header("Content-Type: application/vnd.ms-excel");
                            header("Content-Disposition: attachment; filename=".$fileName);
                            header("Cache-Control: max-age=0");
            
                            // Save Excel 2007 file
                            $objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel2007');
                            // echo str_replace('.php', '.xlsx', __FILE__);
                            // echo $excel_file_path;
                            //$objWriter->save(str_replace('.php', '.xlsx', __FILE__));
                            $objWriter->save($excel_file_path);
            
                            unset($objWriter);
                            unset($objPHPExcel);
                            unset($sftp);
            
                            $sftp = new SFTP($ftp_server);
            
                            if ($sftp->login($ftp_username, $ftp_password)) {
                                if(!$sftp -> chdir($ftp_remote_path.'/'.$year.'/'.$date.'/'.$plan_id.'/monthly_report')){
                                    $sftp -> mkdir($ftp_remote_path.'/'.$year.'/'.$date.'/'.$plan_id.'/monthly_report');
                                }
                                $remote_monthly_file ="$ftp_remote_path/$year/$date/$plan_id/monthly_report/";
                                //$remote_weekly_file = "/"; 
                                $excel_file_path = "../ftp_uploads/$date/$plan_id/$fileName";
            
                                if($sftp->chdir($remote_monthly_file)){
                                //if($sftp->put($remote_weekly_file.$fileName, $excel_file_path , SFTP::SOURCE_LOCAL_FILE)){
                                if($sftp->put($remote_monthly_file.$fileName, $excel_file_path , SFTP::SOURCE_LOCAL_FILE)){
                                    unlink(str_replace('.php', '.xlsx', __FILE__));
                                    $ftp_excel ="Uploaded excel file";
                                    $log .= "[".date("m-d-Y H:i:s")."] Uploaded excel file".PHP_EOL;
            
                                }else{
                                    $ftp_excel =  "uploaded excel file";
                                    $log .= "[".date("m-d-Y H:i:s")."] Not uploaded excel file".PHP_EOL ;
                                }
                                echo $ftp_excel;
                                }
                            }
                            //$ftp_response = array("FTP_Response" => $go_any_where_status, "FTP_Excel" => $ftp_excel);
                            //$ftp_response = json_decode(json_encode($ftp_response), true);
                            //$response -> status = 1;
                            //$response -> message = "Uploaded to ftp server";
                            //$response -> ftp_response = json_encode($ftp_response);
                            
                        }
                    }else{
                        echo "$plan_id is inactive";
                        //$response = array("status" => 0 ,"FTP Response" =>"$plan_id is inactive");

                        //$response->status = 0;
                        //$response->message = "$plan_id is inactive";
                        $log .= "[".date("m-d-Y H:i:s")."] $plan_id is inactive". PHP_EOL;
                    }
                }else{
                    echo "Unable to login to sftp server";
                    //$response =array( "status" => 0 ,"FTP Response" => "Unable to login to sftp server");
                    //$response->status = 0;
                    //$response->message = "Unable to login to sftp server";
                    $log .= "[".date("m-d-Y H:i:s")."] Unable to login to sftp server". PHP_EOL;
                }
            }else{
                $log .= "[".date("m-d-Y H:i:s")."]".json_encode("No client is active with $plan_id"). PHP_EOL;
                $log.="-------------------------------------------------------------------------------------------------------------".PHP_EOL.PHP_EOL;
                file_put_contents($log_file_path, $log, FILE_APPEND);
                
                echo "No client is active with $plan_id";
                //$response = array("status" => 0 ,"FTP Response" =>"No client is active with $plan_id");
                //return json_encode($response);

                //$response->status = 0;
                  //  $response->message = "No client is active with $plan_id";
                    //$response->fax_response = $fax_response_obejct;
                   // return json_encode($response);

            }
       


        }else{
            $log .= "[".date("m-d-Y H:i:s")."] Plan Id is empty". PHP_EOL;
            //$response = "Plan Id is empty";
            //$response->status = 0;
            //$response->message = "Plan Id is empty";
            echo "Plan Id is empty";
        }

            
            //Save string to log, use FILE_APPEND to append.
            $log.="-------------------------------------------------------------------------------------------------------------".PHP_EOL.PHP_EOL;
            file_put_contents($log_file_path, $log, FILE_APPEND);

        //echo json_encode($response);
        return;
    }

    public function uploadFilesToSftp($plan_id,$year,$memberId,$file_moved_path_location){
       
        //require_once("../db.php");
        include("../db.php");
        require_once("../php_excel/PHPExcel.php");
            
        date_default_timezone_set('America/New_York');
        $current_date = date("Y-m-d H:i:s");
        $date = date("mdY");
        //$year = isset($_GET['year'])? $_GET['year'] : date("Y");

            $response = new stdClass();
                
            $log = "";
            $log_path = "../../../pre_live_focuscares_api_ftp_logs";

            
            $log_file = $plan_id."_".$date.".log";
            $log_file_path = "$log_path/$date/$plan_id/$log_file";

            //Log File Path Creation
            FileIOUtility::SftplogFilePath($log_path,$date,$plan_id,$log_file);
	        
            $log = "";
            $log .= "[".date("m-d-Y H:i:s")."] Server Parameters : ".json_encode($_SERVER).PHP_EOL. PHP_EOL;
            $log .= "[".date("m-d-Y H:i:s")."] Client : $plan_id". PHP_EOL;
            $log .= "[".date("m-d-Y H:i:s")."] Year : $year". PHP_EOL;
            $log .= "[".date("m-d-Y H:i:s")."] Member Id : $memberId". PHP_EOL;
            file_put_contents($log_file_path, $log, FILE_APPEND);
            
            if($plan_id != ""){

                // Excel file name for download 
                $fileName = "FocusCare_Weekly Upload Report_Date $date.xlsx";             
            
                $excel_file_path = "../ftp_uploads/$date/$plan_id/$fileName";

                FileIOUtility :: SftpExcelUploadFolder($date, $plan_id, $fileName);
                
            
            
                // Create new PHPExcel object
                $objPHPExcel = new PHPExcel();
            
                if(file_exists($excel_file_path)){
                    $objReader = PHPExcel_IOFactory::createReader("Excel2007");
            
                    $objPHPExcel = $objReader->load($excel_file_path);
                    $highest_row = $objPHPExcel->setActiveSheetIndex(0)->getHighestRow();
            
                    $i = $highest_row;
                    $j = $highest_row - 1;
                }else{
            
                    $objPHPExcel->setActiveSheetIndex(0)
                        ->setCellValue('A1', 'Plan')
                        ->setCellValue('B1', 'Program')
                        ->setCellValue('C1', 'Year')
                        ->setCellValue('D1', 'LOB')
                        ->setCellValue('E1', 'Member ID')
                        ->setCellValue('F1', 'Member First Name')
                        ->setCellValue('G1', 'Member Last Name')
                        ->setCellValue('H1', 'Visit Type')
                        ->setCellValue('I1', 'Assessment Naming Convention')
                        ->setCellValue('J1', 'Date of Service')
                        ->setCellValue('K1', 'Date of Upload')
                        ->setCellValue('L1', 'HRA Assessment Status')
                        ->setCellValue('M1', 'HRA Assessment Reason')
                        ->setCellValue('N1', 'PCP Summary Status')
                        ->setCellValue('O1', 'PCP Summary Reason');
                    $i=1;
                    $j=0;
                }
            
                $ftp_server = "";
                $ftp_username = "";
                $ftp_password = "";
                $ftp_remote_path = "";
           
                $query = "SELECT * FROM `hra_ftp_details` WHERE plan = 'DEMO'";
                
                file_put_contents($log_file_path, $log, FILE_APPEND);
                $select_query = mysqli_query($conn,$query);
          
                if(mysqli_num_rows($select_query) >= 1){
                    $ftp_details = mysqli_fetch_assoc($select_query);
                    if($ftp_details['active_status']=='Y'){
                        $ftp_server = $ftp_details['ftp_host'];
                        $ftp_username = $ftp_details['ftp_user'];
                        $ftp_password = $ftp_details['ftp_password'];
                        $ftp_remote_path = "/".$ftp_details['ftp_remote_path'];
             
                        $log .= "[".date("m-d-Y H:i:s")."] FTP HOST : ". base64_encode(convert_uuencode(base64_encode($ftp_server))).PHP_EOL.
                               "FTP USERNAME : ". base64_encode(convert_uuencode(base64_encode($ftp_username))).PHP_EOL
                        ;
            
                    }else{
                        $log .= "[".date("m-d-Y H:i:s")."]".json_encode("$plan_id is not active for uploading files to FTP Server").PHP_EOL;
                        $log.="-------------------------------------------------------------------------------------------------------------".PHP_EOL.PHP_EOL;
                        file_put_contents($log_file_path, $log, FILE_APPEND);

                        //$response =array("status" => 0 ,"FTP Response" =>"$plan_id is not active for uploading files to FTP Server");
                        $response->status = 0;
                        $response->message = "$plan_id is not active for uploading files to FTP Server";
                        //$response->fax_response = $fax_response_obejct;
		                return json_encode($response);
                        
                    }
                }else{
                    $log .= "[".date("m-d-Y H:i:s")."]".json_encode("No client is active with $plan_id"). PHP_EOL;
                    $log.="-------------------------------------------------------------------------------------------------------------".PHP_EOL.PHP_EOL;
                    file_put_contents($log_file_path, $log, FILE_APPEND);
                    
                    //$response = array("status" => 0 ,"FTP Response" =>"No client is active with $plan_id");
                    //return json_encode($response);

                    $response->status = 0;
                        $response->message = "No client is active with $plan_id";
                        //$response->fax_response = $fax_response_obejct;
		                return json_encode($response);

                }
            
            
            
            
                $sftp = new SFTP($ftp_server);
            
                if ($sftp->login($ftp_username, $ftp_password)) {
 
                    if(!$sftp -> chdir($ftp_remote_path)){
                        $sftp -> mkdir($ftp_remote_path);
                        if(!$sftp -> chdir($ftp_remote_path.'/'.$year)){
                            $sftp -> mkdir($ftp_remote_path.'/'.$year);
                            if(!$sftp -> chdir($ftp_remote_path.'/'.$year.'/'.$date)){
                                $sftp -> mkdir($ftp_remote_path.'/'.$year.'/'.$date);
                            }elseif($sftp -> chdir($ftp_remote_path.'/'.$year)){
                                if(!$sftp -> chdir($ftp_remote_path.'/'.$year.'/'.$date)){
                                    $sftp -> mkdir($ftp_remote_path.'/'.$year.'/'.$date);
                                }
                            }
                        }
                    }else{
                        if(!$sftp -> chdir($ftp_remote_path.'/'.$year)){
                            $sftp -> mkdir($ftp_remote_path.'/'.$year);
                            if(!$sftp -> chdir($ftp_remote_path.'/'.$year.'/'.$date)){
                                $sftp -> mkdir($ftp_remote_path.'/'.$year.'/'.$date);
                            }
                        }elseif($sftp -> chdir($ftp_remote_path.'/'.$year)){
                            if(!$sftp -> chdir($ftp_remote_path.'/'.$year.'/'.$date)){
                                $sftp -> mkdir($ftp_remote_path.'/'.$year.'/'.$date);
                            }
                        }
                    }
            
            
                    if($sftp -> chdir($ftp_remote_path.'/'.$year.'/'.$date)){
                        $sftp -> mkdir($ftp_remote_path.'/'.$year.'/'.$date.'/'.$plan_id);
                        if($sftp ->chdir($ftp_remote_path.'/'.$year.'/'.$date.'/'.$plan_id)){
                            if(!$sftp -> chdir($ftp_remote_path.'/'.$year.'/'.$date.'/'.$plan_id.'/hra_assessment')){
                                $sftp -> mkdir($ftp_remote_path.'/'.$year.'/'.$date.'/'.$plan_id.'/hra_assessment');
                            }
                            if(!$sftp -> chdir($ftp_remote_path.'/'.$year.'/'.$date.'/'.$plan_id.'/summary_report')){
                                $sftp -> mkdir($ftp_remote_path.'/'.$year.'/'.$date.'/'.$plan_id.'/summary_report');
                            }
                        }else{
                            if(!$sftp -> chdir($ftp_remote_path.'/'.$year.'/'.$date.'/'.$plan_id.'/hra_assessment')){
                                $sftp -> mkdir($ftp_remote_path.'/'.$year.'/'.$date.'/'.$plan_id.'/hra_assessment');
                            }
                            if(!$sftp -> chdir($ftp_remote_path.'/'.$year.'/'.$date.'/'.$plan_id.'/summary_report')){
                                $sftp -> mkdir($ftp_remote_path.'/'.$year.'/'.$date.'/'.$plan_id.'/summary_report');
                            }
                        }
                    }
            
                    $getClientsids =  "SELECT active_status,clientId, program FROM HRA_client LEFT JOIN hra_ftp_details as ftp ON ftp.plan = HRA_client.plan where HRA_client.plan= '".$plan_id."' and year like  '%".$year."%' ";
                    //$getClientsids =  "SELECT clientId, program FROM HRA_client where HRA_client.plan= '".$plan_id."' and year like  '%".$year."%' ";
            
                    $getClientsidsresult=mysqli_query($conn,$getClientsids);
                    $sql_global_member_query = array();
                    $sql_global_member_query1 = array();
            
                    while($getClientsidsresp=mysqli_fetch_array($getClientsidsresult,MYSQLI_ASSOC)){
                        $client_id =  $getClientsidsresp['clientId'];
                        $substatus_column = "";
            
                        $overrideScheduleDate_column = "(
                            CASE
                            WHEN EvaluationDate IS NOT NULL AND scheduleDate IS NOT NULL THEN EvaluationDate 
                            ELSE scheduleDate
                            END
                        ) AS  overrideScheduledDate";
            
                        $overrideShortScheduleDate_column = "(
                            CASE
                                WHEN EvaluationDate IS NOT NULL AND scheduleDate IS NOT NULL THEN STR_TO_DATE(EvaluationDate, '%Y-%m-%d')
                                ELSE STR_TO_DATE(scheduleDate, '%Y-%m-%d')
                            END
                            ) AS  overrideShortScheduledDate";
                        $completed_date_column = "( CASE 
                            WHEN JSON_LENGTH(JSON_UNQUOTE(JSON_EXTRACT(hraStatusHistory, '$.completed'))) <> 0 THEN JSON_UNQUOTE(JSON_EXTRACT(hraStatusHistory,CONCAT('$.completed[',JSON_LENGTH(`hraStatusHistory` , '$.completed')-1,'].date')))
            
            
                            END ) AS completed_date";
            
                        $combine_member_query[] = "select member_id, $completed_date_column,hraStatus,clientid,year, memberinfo,$overrideScheduleDate_column,$overrideShortScheduleDate_column,scheduleDate, VisitType, pdf_file_name,summary_pdf_file_name,Ftp_upload_status from HRA_member_".$client_id.'_'.$year;
                        $combine_member_query1['active'] = $getClientsidsresp['active_status'];
                    } 
                    $combine_member_query1['active']='Y';
                    if($combine_member_query1['active']=='Y'){
                        if($combine_member_query && is_array($combine_member_query))
                        {
                            $sql_global_member_query1 = implode(" UNION ALL ", $combine_member_query);
                            
            
                            //$sql_global_member_query1 = "select (COUNT(*) OVER()) as totalRows,member_info.* from (". $sql_global_member_query1 . " ) as  member_info  where JSON_UNQUOTE(JSON_EXTRACT(member_info.hraStatus, '$.hraStatus')) in(10,11)  AND  pdf_file_name !='' AND (Ftp_upload_status IS NULL or Ftp_upload_status='' ) AND member_id = '$memberId' limit 100";
            
                            $sql_global_member_query1 = "select (COUNT(*) OVER()) as totalRows,member_info.* from (". $sql_global_member_query1 . " ) as  member_info  where JSON_UNQUOTE(JSON_EXTRACT(member_info.hraStatus, '$.hraStatus')) in(10,11)  AND  pdf_file_name !='' AND member_id = '$memberId' limit 100";

                            //echo $sql_global_member_query1;exit;
                            $log .= "[".date("m-d-Y H:i:s")."] QUERY : $sql_global_member_query1". PHP_EOL;
                            file_put_contents($log_file_path, $log, FILE_APPEND);

                            $memberrecordscount = mysqli_query($conn,$sql_global_member_query1);
            
                            $go_any_where_status = array("hra_uploadStatus" => "failed", "summary_uploadStats" => "failed" , "reason_hra" => "", "reason_summary" => "" , "member_id" => "" , "client_id" => $client_id , "year" => $year, "ftp_upload_date" => $current_date , "assessment_name" => "", 'summary_assessment_name' => "");
                            if(mysqli_num_rows($memberrecordscount)){
                            while($member_row = mysqli_fetch_array($memberrecordscount,MYSQLI_ASSOC))
                            {
                                //$response[] = $member_row;
                                $i++;
                                $j++;
                                $memberId = $member_row['member_id'];
                                $clientId = $member_row['clientid'];
                                $year = $member_row['year'];
                                $form_type = "form_pdf";
                                $fileepath = "../member_data/HRA_member_".$clientId.'/'.$year;
                                $local_file_to_upload = $fileepath.'/'.$form_type.'/'.$memberId.'.pdf';
                                $local_file_to_upload_summary = $fileepath.'/'.'summary_report'.'/'.$memberId.'.pdf';
            
                                $file_name_with_extention = $memberId.'.pdf';
            
            
            
                                $meminfo =  json_decode($member_row['memberinfo'],true);
                                if($member_row['pdf_file_name'] != ''){
                                    $file_name = $member_row['pdf_file_name'].'.pdf';
                                }else{
                                    // $file_name = $file_name_with_extention;
                                    $file_name = "$plan_id"."_".$meminfo['LOB'].'_'.$meminfo['Member_Region'].'_'.$member_row['VisitType'].'_'.$meminfo['Member_Last_name'].'_'.$memberId.'_.pdf';
                                }
            
                                if($plan_id == "VPHP" || $plan_id == "OHP-OPTIMA"){
                                    if($member_row['summary_pdf_file_name'] !=''){
                                        $file_name_summary = $member_row['summary_pdf_file_name'];
                                    }else{
                                        $file_name_summary = 'Summary_'.$memberId.'.pdf';
                                    }
                                }elseif($plan_id == "Southwestern Health" || $plan_id == "Alliant Health Plans"){
                                    if($member_row['summary_pdf_file_name'] !=''){
                                        $file_name_summary = $member_row['summary_pdf_file_name'].".pdf";
                                    }
                                }else{
                                    if($member_row['summary_pdf_file_name'] !=''){
                                        $file_name_summary = $member_row['summary_pdf_file_name'].".pdf";
                                    }
                                }

                                /*if(strtolower(substr($file_name_summary, -4)) == '.pdf'){
                                    if($member_row['summary_pdf_file_name'] !=''){
                                        $file_name_summary = $member_row['summary_pdf_file_name'];
                                    }else{
                                        $file_name_summary = 'Summary_'.$memberId.'.pdf';
                                    }
                                }else{
                                    if($member_row['summary_pdf_file_name'] !=''){
                                        $file_name_summary = $member_row['summary_pdf_file_name'].".pdf";
                                    }
                                }*/
                                
            
                                $file_name = str_replace("*","_",$file_name);
                                $file_name_summary = str_replace("*","_",$file_name_summary);

                                $program = $meminfo['Program'];
            
                                $remote_file_path_hra="$ftp_remote_path/$year/$date/$plan_id/hra_assessment";
                                //$remote_file_path_hra = "$ftp_remote_path/";
                                $remote_file_path_summary="$ftp_remote_path/$year/$date/$plan_id/summary_report/";
            
                                $log .= "[".date("m-d-Y H:i:s")."] HRA Assessment File Path : ". $remote_file_path_hra. PHP_EOL;
                                $log .= "[".date("m-d-Y H:i:s")."] PCP Summary File Path : ". $remote_file_path_summary. PHP_EOL;
            
                                
            
                                $go_any_where_status = array("hra_uploadStatus" => "failed", "summary_uploadStats" => "failed" , "reason_hra" => "", "reason_summary" => "" , "member_id" => $memberId , "client_id" => $clientId , "year" => $year, "ftp_upload_date" => $current_date , "assessment_name" => $file_name, 'summary_assessment_name' => $file_name_summary);
            
                                if(file_exists($local_file_to_upload))
                                {
                                    if($sftp->chdir($remote_file_path_hra)){
                                    if($sftp->put($file_name, $local_file_to_upload, SFTP::SOURCE_LOCAL_FILE)){
            
                                        $go_any_where_status = array("hra_uploadStatus" => "success", "summary_uploadStats" => "failed" , "reason_hra" => "uploaded for HRA Assessment" ,"reason_summary" => "", "member_id" => $memberId , "client_id" => $clientId , "year" => $year , "ftp_upload_date" => $current_date , "assessment_name" => $file_name, 'summary_assessment_name' => $file_name_summary);
                                    }else{
                                        $go_any_where_status = array("hra_uploadStatus" => "failed", "summary_uploadStats" => "failed" , "reason_hra" => "not uploaded in ftp server for HRA Assessment" , "reason_summary" => "" , "member_id" => $memberId , "client_id" => $clientId , "year" => $year , "ftp_upload_date" => $current_date , "assessment_name" => $file_name, 'summary_assessment_name' => $file_name_summary);   
                                    }
                                     }else{
                                         $go_any_where_status = array("hra_uploadStatus" => "failed", "summary_uploadStats" => "failed" , "reason_hra" => "directory $remote_file_path_hra not existed in ftp server for HRA Assessment" , "reason_summary" => "","member_id" => $memberId , "client_id" => $clientId , "year" => $year , "ftp_upload_date" => $current_date , "assessment_name" => $file_name, 'summary_assessment_name' => $file_name_summary);    
                                     }
            
                                }else{
                                    $go_any_where_status = array("hra_uploadStatus" => "failed", "summary_uploadStats" => "failed" , "reason_hra" => "$file_name is not existed for HRA Assessment" , "reason_summary" => "" ,"member_id" => $memberId , "client_id" => $clientId , "year" => $year , "ftp_upload_date" => $current_date , "assessment_name" => $file_name, 'summary_assessment_name' => $file_name_summary);   
                                }
            
                                $hra_status = $go_any_where_status['hra_uploadStatus'];
                                $hra_reason = $go_any_where_status['reason_hra'];
                    
                                $file_name_summary1  = str_replace("/","_",$file_name_summary );

                                if(file_exists($local_file_to_upload_summary))
                                {
                                    if($sftp->chdir($remote_file_path_summary)){
                                        if($sftp->put($file_name_summary1, $local_file_to_upload_summary, SFTP::SOURCE_LOCAL_FILE)){
                                            
                                            $go_any_where_status = array("hra_uploadStatus" => $hra_status, "summary_uploadStats" => "success" , "reason_hra" => $hra_reason,  "reason_summary" => "uploaded for Summary Assessment" , "member_id" => $memberId , "client_id" => $clientId , "year" => $year , "ftp_upload_date" => $current_date , "assessment_name" => $file_name, 'summary_assessment_name' => $file_name_summary);
                                        }else{
                                            $go_any_where_status = array("hra_uploadStatus" => $hra_status, "summary_uploadStats" => "failed" , "reason_hra" => $hra_reason,  "reason_summary" =>  "not uploaded in ftp server for Summary Assessment" , "member_id" => $memberId , "client_id" => $clientId , "year" => $year , "ftp_upload_date" => $current_date , "assessment_name" => $file_name, 'summary_assessment_name' => $file_name_summary);   
                                        }
                                    }else{
                                        $go_any_where_status = array("hra_uploadStatus" => $hra_status, "summary_uploadStats" => "failed" , "reason_hra" => $hra_reason,  "reason_summary" =>  "directory $file_name_summary not existed in ftp server for Summary Assessment" , "member_id" => $memberId , "client_id" => $clientId , "year" => $year , "ftp_upload_date" => $current_date , "assessment_name" => $file_name, 'summary_assessment_name' => $file_name_summary);    
                                    }
                                    
                                }else{
                                    $go_any_where_status = array("hra_uploadStatus" => $hra_status, "summary_uploadStats" => "failed" , "reason_hra" => $hra_reason,  "reason_summary" =>  "$file_name is not existed for Summary Assessment" , "member_id" => $memberId , "client_id" => $clientId , "year" => $year , "ftp_upload_date" => $current_date , "assessment_name" => $file_name, 'summary_assessment_name' => $file_name_summary);   
                                }
            
                                $file_name = mysqli_real_escape_string($conn,$file_name);
                                $update_Query = "UPDATE HRA_member_".$clientId.'_'.$year. " SET Ftp_upload_status = '".json_encode($go_any_where_status)."' where member_id = ". $memberId;
                                //echo $update_Query;
                                mysqli_query($conn, $update_Query) ;
                                //echo json_encode($go_any_where_status);
                                $log .= "[".date("m-d-Y H:i:s")."] ". json_encode($go_any_where_status).PHP_EOL;
                                //exit;
                                if($go_any_where_status['hra_uploadStatus'] == "failed"){
                                    $local_file_to_upload = mysqli_real_escape_string($conn,$local_file_to_upload);
                                    $memberId = mysqli_real_escape_string($conn,$memberId);
                                    $insert_query = "INSERT INTO ftp_error_logs( member_id, clientid, `year`, filepath, cron_type, reason) VALUES ('$memberId','$clientId',$year,'$local_file_to_upload','Weekly_Upload_Completed_records_hra_assessment','".$go_any_where_status['reason_hra']."') ";
            
                                    //echo $insert_query;
            
                                    $query = mysqli_query($conn,$insert_query);
            
                                }
            
                                if($go_any_where_status['summary_uploadStatus'] == "failed"){
                                    $local_file_to_upload = mysqli_real_escape_string($conn,$local_file_to_upload);
                                    $memberId = mysqli_real_escape_string($conn,$memberId);
                                    $insert_query = "INSERT INTO ftp_error_logs( member_id, clientid, `year`, filepath, cron_type, reason) VALUES ('$memberId','$clientId',$year,'$local_file_to_upload','Weekly_Upload_Completed_records_summary_assessment','".$go_any_where_status['reason_summary']."') ";
                                    //echo $insert_query;
                                    $query = mysqli_query($conn,$insert_query) or die($conn -> mysqli_error());
                                }
            
            
                                $objPHPExcel->setActiveSheetIndex(0)
                                    ->setCellValue("A$i", $plan_id)
                                    ->setCellValue("B$i", $program)
                                    ->setCellValue("C$i", $year)
                                    ->setCellValue("D$i", $meminfo['LOB'])
                                    ->setCellValue("E$i", $memberId)
                                    ->setCellValue("F$i", $meminfo['Member_first_name'])
                                    ->setCellValue("G$i", $meminfo["Member_Last_name"])
                                    ->setCellValue("H$i", $member_row['VisitType'])
                                    ->setCellValue("I$i", $file_name)
                                    ->setCellValue("J$i", date("m-d-Y", strtotime($member_row['overrideShortScheduledDate']) ))
                                    ->setCellValue("K$i",  date("m-d-Y"))
                                    ->setCellValue("L$i", $go_any_where_status['hra_uploadStatus'])
                                    ->setCellValue("M$i", $go_any_where_status['reason_hra'])
                                    ->setCellValue("N$i", $go_any_where_status['summary_uploadStats'])
                                    ->setCellValue("O$i", $go_any_where_status['reason_summary']);
            
                            }
                        }else{
                            $i++;
                            $j++;
                            $objPHPExcel->setActiveSheetIndex(0)
                                    ->setCellValue("A$i", $plan_id)
                                    ->setCellValue("B$i", "")
                                    ->setCellValue("C$i", $year)
                                    ->setCellValue("D$i", "")
                                    ->setCellValue("E$i", "$memberId")
                                    ->setCellValue("F$i", "No Data found for $memberId")
                                    ->setCellValue("G$i", "")
                                    ->setCellValue("H$i", "")
                                    ->setCellValue("I$i", "")
                                    ->setCellValue("J$i", "")
                                    ->setCellValue("K$i",  date("m-d-Y"))
                                    ->setCellValue("L$i", "")
                                    ->setCellValue("M$i", "")
                                    ->setCellValue("N$i", "")
                                    ->setCellValue("O$i", "");
                        }
            
            
            
                            $objPHPExcel->getActiveSheet()->setTitle('Sheet1');
            
            
                            // Set active sheet index to the first sheet, so Excel opens this as the first sheet
                            $objPHPExcel->setActiveSheetIndex(0);
            
                            // Redirect output to a client’s web browser (Excel5)
                            header("Content-Type: application/vnd.ms-excel");
                            header("Content-Disposition: attachment; filename=".$fileName);
                            header("Cache-Control: max-age=0");
            
                            // Save Excel 2007 file
                            $objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel2007');
                            // echo str_replace('.php', '.xlsx', __FILE__);
                            // echo $excel_file_path;
                            //$objWriter->save(str_replace('.php', '.xlsx', __FILE__));
                            $objWriter->save($excel_file_path);
            
                            unset($objWriter);
                            unset($objPHPExcel);
                            unset($sftp);
            
                            $sftp = new SFTP($ftp_server);
            
                            if ($sftp->login($ftp_username, $ftp_password)) {
                                if(!$sftp -> chdir($ftp_remote_path.'/'.$year.'/'.$date.'/'.$plan_id.'/weekly_report')){
                                    $sftp -> mkdir($ftp_remote_path.'/'.$year.'/'.$date.'/'.$plan_id.'/weekly_report');
                                }
                                $remote_weekly_file ="$ftp_remote_path/$year/$date/$plan_id/weekly_report/";
                                //$remote_weekly_file = "/"; 
                                $excel_file_path = "../ftp_uploads/$date/$plan_id/$fileName";
            
                                if($sftp->chdir($remote_weekly_file)){
                                //if($sftp->put($remote_weekly_file.$fileName, $excel_file_path , SFTP::SOURCE_LOCAL_FILE)){
                                if($sftp->put($remote_weekly_file.$fileName, $excel_file_path , SFTP::SOURCE_LOCAL_FILE)){
                                    unlink(str_replace('.php', '.xlsx', __FILE__));
                                    $ftp_excel ="Uploaded excel file";
                                    $log .= "[".date("m-d-Y H:i:s")."] Uploaded excel file".PHP_EOL;
            
                                }else{
                                    $ftp_excel =  "uploaded excel file";
                                    $log .= "[".date("m-d-Y H:i:s")."] Not uploaded excel file".PHP_EOL ;
                                }
                                }
                            }
                            $ftp_response = array("FTP_Response" => $go_any_where_status, "FTP_Excel" => $ftp_excel);
                            $ftp_response = json_decode(json_encode($ftp_response), true);
                            $response -> status = 1;
                            $response -> message = "Uploaded to ftp server";
                            $response -> ftp_response = json_encode($ftp_response);
                            
                        }
                    }else{
                        
                        //$response = array("status" => 0 ,"FTP Response" =>"$plan_id is inactive");

                        $response->status = 0;
                        $response->message = "$plan_id is inactive";
                        $log .= "[".date("m-d-Y H:i:s")."] $plan_id is inactive". PHP_EOL;
                    }
                }else{
                    //$response =array( "status" => 0 ,"FTP Response" => "Unable to login to sftp server");
                    $response->status = 0;
                    $response->message = "Unable to login to sftp server";
                    $log .= "[".date("m-d-Y H:i:s")."] Unable to login to sftp server". PHP_EOL;
                }
            }else{

                $log .= "[".date("m-d-Y H:i:s")."] Plan Id is empty". PHP_EOL;
                //$response = "Plan Id is empty";

                $response->status = 0;
                $response->message = "Plan Id is empty";
            }

            
            //Save string to log, use FILE_APPEND to append.
            $log.="-------------------------------------------------------------------------------------------------------------".PHP_EOL.PHP_EOL;
            file_put_contents($log_file_path, $log, FILE_APPEND);

            return json_encode($response);
            
    }

}