<?php

/*
    STRING  UTILTIY FUNCTION
*/
class StringUtility
{   

    /*
        NAME    : removeSpecialCharactersExceptSpace
        TYPE    : global Utiltiy function 
        DETAILS : remove special characters if any except a-z and numbers and white space
    */
    public static function removeSpecialCharactersExceptSpace($text_value)
    {
        return preg_replace( '/[^a-zA-Z0-9\s]/', '', $text_value);
    }

     /*
        NAME    : trimAndRemoveSpecialCharactersExceptSpace
        TYPE    : global Utiltiy function 
        DETAILS : trim white space in start and end if any
                  remove special characters if any except a-z and numbers and white space
    */
    public static function trimAndRemoveSpecialCharactersExceptSpace($text_value)
    {
        $text_value = trim($text_value);
        return preg_replace( '/[^a-zA-Z0-9\s]/', '', $text_value);
    }

    /*
        NAME    : isValueSet
        TYPE    : Utiltiy function 
        DETAILS : the string value is set and not empty and not null
        RETURN  : 
    */
    public static function isValueSet($value)
    {
        $trimed_value = trim($value);//to remove white space
        return (isset($trimed_value) && !empty($trimed_value));
    }

     /*
        NAME    : isValueSetAllowZero
        TYPE    : Utiltiy function 
        DETAILS : the string value is set and not empty and not null
        RETURN  : 
    */
    public static function isValueSetAllowZero($value)
    {
        $trimed_value = trim($value);//to remove white space
        if($trimed_value==="0") 
        {
            return TRUE;
        }
        return (isset($trimed_value) && !empty($trimed_value)) ;
    }

     /*
        NAME    : toEmptyStringIfNull
        TYPE    : Utiltiy function 
        DETAILS : if string value is empty not set or null convert to empty string value
        RETURN  : 
    */
    public static function toEmptyStringIfNull($value)
    {
        if (!isset($value) || empty($value) || $value==null)
        {
            return "";
        }

        return $value;
    }

    /*
        NAME    : splitAndJoinWith
        TYPE    : Utiltiy function 
        DETAILS : split the string with a delimiter and joined with delimiter
        RETURN  : 
    */
    public static function splitAndJoinWith($delimit_string,$split_delimiter,$join_delimiter,$is_quoted=false)
    {
        $string_of_aray = explode($split_delimiter,$delimit_string);

		if(count($string_of_aray))
		{
            if($is_quoted)
            {
                return implode($join_delimiter,
                                    array_map(
                                        function($string_value)
                                        {
                                            return sprintf("'%s'",$string_value);
                                        },
                                        $string_of_aray)
                                    );
            }
            {
                return implode($join_delimiter,$string_of_aray);
            }

		}
        else
        {
            return FALSE;
        }
    }


}

?>