<?php

/*
        CENERAL UTILTIY FUNCTION
*/

require_once('../packages/PHPMailer/src/Exception.php');
require_once('../packages/PHPMailer/src/PHPMailer.php');
require_once('../packages/PHPMailer/src/SMTP.php');

use PHPMailer\PHPMailer\PHPMailer;
use PHPMailer\PHPMailer\Exception;

class Utility
{

    /*
        EMAIL SERVER DETAILS
    */
    const EMAIL_HOST = 'smtp.office365.com';
    const EMAIL_USER_NAME = 'admin@focuscares.com';
    const EMAIL_PASSWORD = 'F0cus@1234';//password reset on 03-08-2021 (d-m-y)

    /*
        NAME    : sendMailTo
        TYPE    : Utiltiy function 
        DETAILS : send mail to a specific address 
        RETURN  : mail send status and error if any 
    */
    public static function sendMailTo($mail_id,$mail_subject,$mail_content)
	{
			
			//create php mailer class instance
            $mail = new PHPMailer(true);
			try 
			{
                //smtp and host  
                $mail->isSMTP();                            
                $mail->Host       = self::EMAIL_HOST; 
                // enable smtp authentication 
                $mail->SMTPAuth   = true;                           
                $mail->Username   = self::EMAIL_USER_NAME;              
                $mail->Password   = self::EMAIL_PASSWORD;
                //for encrypted connection                        
                $mail->SMTPSecure = 'tls';                         
                $mail->Port       = 587;
                //mail details   
                $mail->setFrom(self::EMAIL_USER_NAME, "Focus care HRA"); 
	            $mail->addAddress($mail_id, "Receiver");
                $mail->Subject = $mail_subject;
                $mail->IsHTML(true);
                $mail->Body = $mail_content;
                
				if($mail->send())
				{

					return array("mailStatus"=>'success' , "error"=>$mail->ErrorInfo);
				}
				else
				{

					return array("mailStatus"=>'failed' , "error"=>$mail->ErrorInfo);
				}
				
            }
            catch (Exception $e) 
            { 
                //error handling
				$error = $e->getMessage();
				return array("mailStatus"=>'failed' , "error"=>$error);
			}
			
		return array("mailStatus"=>'failed' , "error"=>'unknown error');
			
    }

    /*
        NAME    : sendMailToMultiple
        TYPE    : Utiltiy function 
        DETAILS : send mail to multiple address 
        RETURN  : mail send status and error if any 
    */
    public static function sendMailToMultiple($mail_id_array,$mail_subject,$mail_content)
	{
			if(!is_array($mail_id_array))
            {
                return array("mailStatus"=>'failed' , "error"=>'empty user mail id');
            }

            if(count($mail_id_array)<=0)
            {
                return array("mailStatus"=>'failed' , "error"=>'empty user mail id');
            }
			//create php mailer class instance
            $mail = new PHPMailer(true);
			try 
			{
                //smtp and host
                $mail->isSMTP();                            
                $mail->Host       = self::EMAIL_HOST; 
                // enable smtp authentication 
                $mail->SMTPAuth   = true;                           
                $mail->Username   = self::EMAIL_USER_NAME;              
                $mail->Password   = self::EMAIL_PASSWORD;
                //for encrypted connection                        
                $mail->SMTPSecure = 'tls';                         
                $mail->Port       = 587;
                //mail details   
                $mail->setFrom(self::EMAIL_USER_NAME, "Sender");
                $mail_address_count = count($mail_id_array);
                for($midx=0;$midx<$mail_address_count;$midx++)
                {
	                $mail->addAddress($mail_id_array[$midx], "Receiver");
                }
                $mail->Subject = $mail_subject;
                $mail->IsHTML(true);
                $mail->Body = $mail_content;
              
				if($mail->send())
				{

					return array("mailStatus"=>'success' , "error"=>$mail->ErrorInfo);
				}
				else
				{

					return array("mailStatus"=>'failed' , "error"=>$mail->ErrorInfo);
				}
				
            }
            catch (Exception $e) 
            { 
                //error handling
				$error = $e->getMessage();
				return array("mailStatus"=>'failed' , "error"=>$error);
			}
			
		return array("mailStatus"=>'failed' , "error"=>'unknown error');
			
    }
    /*
        NAME    : failedMailResponse
        TYPE    : global Utiltiy function 
        DETAILS : when mail sent failed response with specific error for 
        RETURN  : failed mailStatsu with error
    */
    public static function failedMailResponse($error)
    {
        return array("mailStatus"=>'mailSentFailed',"error"=>$error);
    }

    /*
        NAME    : validateEmailAddress
        TYPE    : Utiltiy function 
        DETAILS : Utility function to validate email address string is in correct format
        RETURN  : true else false
    */
    public static function validateEmailAddress($email_address) 
    {
        $email_address = trim($email_address);
        $email_address = stripslashes($email_address);
        $email_address = htmlspecialchars($email_address);

        if (!filter_var($email_address, FILTER_VALIDATE_EMAIL)) {
            return false;
        }

        return true;
    }

    /*
        NAME    : generatePasswordHash
        TYPE    : Utiltiy function 
        DETAILS : 
        RETURN  : 
    */
    public static function generatePasswordHash($password)
    {
        $password_hash = password_hash( $password, PASSWORD_DEFAULT);
        return $password_hash;
    }

     /*
        NAME    : validatePasswordHash
        TYPE    : Utiltiy function 
        DETAILS : 
        RETURN  : 
    */
    public static function validatePasswordHash($password,$password_hash)
    {
        return password_verify($password,$password_hash);
    }

     /*
        NAME    : parseRequestBodyFormat
        TYPE    : Utiltiy function 
        DETAILS : 
        RETURN  : 
    */
    public static function parseRequestBodyFormat($associative = true)
	{
		$import_request_format = file_get_contents("php://input");
		return json_decode($import_request_format,$associative);
    }


    /*
        NAME    : emptyStringIfNotValueSet
        TYPE    : Utiltiy function 
        DETAILS : 
        RETURN  : 
    */
    public static function emptyStringIfNotValueSet($value)
    {
        return isset($value) ? $value:'';
    }

     /*
        NAME    : isEmptyAndNotSet
        TYPE    : Utiltiy function 
        DETAILS : the value is empty and value not set (null,not defined)
        RETURN  : 
    */
    public static function isEmptyAndNotSet($value)
    {
        return (!isset($value) || empty($value));
    }

     /*
        NAME    : convertNumberSuffix
        TYPE    : Utiltiy function 
        DETAILS : convert the number into number with 'st','nd','rd' or 'th' suffix
        RETURN  : number with suffix string
    */
    public static function convertNumberSuffix($number_value)
    {
        if(is_numeric($number_value))
        {
            $mod_of_number = $number_value%100;
            switch($mod_of_number)
            {
                case 1: return $number_value.'st';
                case 2: return $number_value.'nd';
                case 3: return $number_value.'rd';
                default : return $number_value.'th';
            }
        }

        return NULL;
    }


}

?>